package openq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

import com.nortel.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.GetVersionRequest;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.IntrinsicArray;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.openq.CreateOQContactFailedFault;
import com.nortel.soa.oi.openq.GetVersionFault;
import com.nortel.soa.oi.openq.LogInFailedFault;
import com.nortel.soa.oi.openq.LogOffSessionFailedFault;
import com.nortel.soa.oi.openq.OpenQ;
import com.nortel.soa.oi.openq.SOAOIOpenQ;

public class OpenQueueTutorial {
	static String username = "OpenWsUser";
	static String password = "Password123";		
	static String domain = "open_queue";	
	static String host = "localhost:9080";	
	static OpenQ  service = null;
	static SsoToken sso = null;

	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		 try{
			 
			
			 if(args == null || args.length ==0){
				 System.out.println("default args[1] - host[" + host +"]");
				 System.out.println("OpenQueue Web Service url[http://" + host + "]/SOAOI/services/OpenQ?wsdl");
			 }else{
				 
				 if(args.length >=1){
					 host = args[1];
				 }
				 
			 }
			 
			 // STEP 2 - Create the Service 
			 createService();
			 		 
			 // STEP 3 - Authenticate User
			 login();
		  
			 // STEP 4  Import the file
  		   	 HashMap headerMap = new HashMap();
			    
			  
  		   	 //create BufferedReader to read csv file
  		   	 BufferedReader br = new BufferedReader( new FileReader("intrinsics.csv"));
			  
			 String strLine = "";
 		     StringTokenizer st = null;
			 IntrinsicArray intrinsicArray = new IntrinsicArray();
	         List<Intrinsic> intrinsics = intrinsicArray.getItem();
			   
		     int lineNumber = 0, tokenNumber = 0;
			 String contactId = null;
			 Contact contact = null;
			  
			 //read comma separated file line by line
 		 	 while( (strLine = br.readLine()) != null) {
			  
				   lineNumber++;
				  
				   //break comma separated line using ","
				  
				   st = new StringTokenizer(strLine, ",");
				  
				    
				  
				   while(st.hasMoreTokens()){
					   
					   tokenNumber++;
					   intrinsics.clear();
					   
					   // Process Header
					   if(lineNumber == 1){
						   headerMap.put(tokenNumber, st.nextToken()); 
					   }else{
						   //display csv values
						   
						   
						   if(tokenNumber == 1){
							   contactId = st.nextToken();
						   }else{
							   Intrinsic intrinsic = new Intrinsic();
							   intrinsic.setKey((String)headerMap.get(tokenNumber));
							   intrinsic.setValue(st.nextToken());
							   intrinsic.setImmutable(true);
							   
							   intrinsics.add(intrinsic);
									  
						   }								   
						  }
		   
				    }// end while
					
				   
				   // STEP 5  Add the Contact
			   		try{
			   			// ignore the header
			   			if(lineNumber > 1){
			   				contact = addContact(contactId, intrinsicArray);
			   			}
			   			
				   	}catch(Exception ex){
				   		System.out.println("Error: Unable to Create contact with externalId[" + contactId +"], error[" + ex.getMessage() + "]");
				   	}
				   	
				   	
				   	if(contact != null){
					  System.out.println("created contact id[" + contact.getContactId()+ "], externalId[" + contact.getExternalContactId() + "]." );
				   	}			  
					//reset token number
					tokenNumber = 0;
			  
			  }
		  
		    
		  
		    
		  
		   }
		  
		   catch(Exception ex){
			   ex.printStackTrace();
		  
		   }finally{
			   
			   // STEP 6  Logout
			   logout();
		   }
		  

	}

	/*
	 * Configure the proxies to point to the CCMS server.
	 */
	public static void createService() throws MalformedURLException, GetVersionFault{

		String serviceUrl = "http://" + host + "/SOAOI/services/OpenQ?wsdl";
	    URL url = new URL(serviceUrl);
	    service = new SOAOIOpenQ(url).getOpenQ();     
	    
	    
	    System.out.println("createService(): service[" + (service == null ?"null": service.getVersion(new GetVersionRequest())) + "]");
	}
	
	/*
	 * Supply the user credentials to authenticate the application with the web service.
	 */
	public static void login(){

		
		try{
			AuthenticationLevel details = new AuthenticationLevel();
			 details.setUsername(username);
			 details.setPassword(password);		
			 details.setDomain(domain);	
			 
			sso = service.logIn(details);
			
		}catch(LogInFailedFault liex){
			System.out.println("A login error has occured. This may indicate another application is currently logged in.");
			System.out.println("Please try again in a few seconds.");
			System.out.println("error[" +liex + "]");
			
			System.exit(0);
		}
		
	}
	
	/*
	 * Create a new contact with the specified externalId and the supplied intrinsics.
	 */
	public static Contact addContact(String id, IntrinsicArray intrinsics) throws CreateOQContactFailedFault{
      
		return service.createOQContact(id, "SourceName", intrinsics, sso);
		
	}
	
	public static void logout(){
		
		try {
			AuthenticationLevel details = new AuthenticationLevel();
			 details.setUsername(username);
			 details.setPassword(password);		
			 details.setDomain(domain);	
			 
			com.nortel.soa.oi.openq.types.LogOffSessionRequestType request = new com.nortel.soa.oi.openq.types.LogOffSessionRequestType();
			request.setAuthenticationLevel(details);
			// log off session
		
			service.logOffSession(request);
		} catch (LogOffSessionFailedFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
}
